﻿$(document).ready(function () {
    $(".imageAreaEvaluator .imageMap").each(function () {
        $(this).disableSelection();

        var imageMap = $(this);
        $(imageMap).imagesLoaded().always(function (instance) {
            $.each(instance.images, function (key, value) {
                var image = $(value.img);
                var width = image.width();
                var height = image.height();
                var imagePosition = image.position();

                var borderLeftWidth = parseInt(image.css("border-left-width").replace("px", ""));
                if (isNaN(borderLeftWidth)) {
                    borderLeftWidth = 0;
                }

                var borderTopWidth = parseInt(image.css("border-top-width").replace("px", ""));
                if (isNaN(borderTopWidth)) {
                    borderTopWidth = 0;
                }

                $(".area", imageMap).each(function () {
                    $(this).width(Math.round(Math.min($(this).attr("data-width") * width, width)));
                    $(this).height(Math.round(Math.min($(this).attr("data-height") * height, height)));
                    $(this).css("left", Math.ceil(($(this).attr("data-left") * width) + borderLeftWidth + imagePosition.left));
                    $(this).css("top", Math.ceil(($(this).attr("data-top") * height) + borderTopWidth + imagePosition.top));

                    var selectedChoice = $(this).find(".choiceList select option:selected");
                    $(this).attr("title", selectedChoice.text().trim());
                    selectedChoice.prop("defaultSelected", true);
                
                    if ($("#MainPageDiv").length && $("#MainPageDiv").hasClass("hideTooltips")) {
                        $(this).removeAttr("title");
                    }

                    UpdateImageMapAreaColor($(this));
                });

            });
        });
    });

    $(".imageAreaEvaluator .imageMap .area")
        .on("mouseenter", function () {
            $(this).addClass("highlightedImageArea");
            UpdateImageMapAreaColor($(this));
        })
        .on("mouseleave", function () {
            $(this).removeClass("highlightedImageArea");
            UpdateImageMapAreaColor($(this));
        });

    $(".imageAreaEvaluator .imageMap .area").on("click", function () {
        var selectedChoice = $(this).find(".choiceList select option:selected");
        var nextChoice = selectedChoice.nextAll("option:not(:disabled)").first();
        
        //IE support for choice evaluator skiplogic since disable is not working correctly
        if (nextChoice.css('display') == 'none')
            nextChoice = null;

        if (nextChoice.length == 0) {
            nextChoice = $(this).find(".choiceList select option:first");
        }

        selectedChoice.prop("selected", false);
        nextChoice.prop("selected", true);
        $(this).find(".choiceList select").trigger("change");
        $(this).attr("title", nextChoice.text().trim());

        if ($("#MainPageDiv").length && $("#MainPageDiv").hasClass("hideTooltips")) {
            $(this).removeAttr("title");
        }

        UpdateImageMapAreaColor($(this));
    });
});

function UpdateImageMapAreaColor(area) {
    var color = area.find(".choiceList select option:selected").attr("data-color");

    if (!color && area.hasClass("highlightedImageArea")) {
        var imageMap = area.closest(".imageMap");
        color = imageMap.attr("data-highlightcolor");
    }

    if (color) {
        area.css("background-color", color);
    }
    else {
        area.css("background-color", "");
    }
}